package w83a.w83aOperacionesPaso.w83aResultados;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesPdf;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import w83a.w83aUtilidadesComunes.W83aUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaCuadroResultadosPdfAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	    List lista=new ArrayList();
	    Map m = new HashMap();
        
        Map mapa = (HashMap)contexto.get("w83aMapResultadosBean");
        Map cab = (HashMap)contexto.get("w83aMapCabeceraResultadosBean");
        W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }      
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		Document document = new Document();			
		
		Font fonttitulo = FontFactory.getFont("Arial", 12, Font.BOLD);
		Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);

		 if (!"0".equals(resultadoBean.getTerritorio())){
			document = new Document(PageSize.A4); //Creo un documento 			
		 }
		 else{
			document = new Document(PageSize.A4.rotate()); //Creo un documento 			    	
		 }
		document.setMargins(30, 30, 80, 40);				
	    
		PdfWriter.getInstance(document, response.getOutputStream());		
		response.setContentType("application/pdf");		
    	response.setHeader("Content-Disposition", "attachment;filename=CuadroResumenResultados.pdf;");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        response.setStatus(HttpServletResponse.SC_OK);
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance(document, baos);
        
        //Evento para cabecera de pgina
        if (!"0".equals(resultadoBean.getTerritorio())){
        	Rectangle rct = new Rectangle(36, 40, 589, 788);
            writer.setBoxSize("art", rct);	
		 }
		 else{
			 Rectangle rct = new Rectangle(54, 36, 788 , 589);
		     writer.setBoxSize("art", rct); 			    	
		 }
		
        
        W83aUtilidadesPdf.HeaderFooter event = new W83aUtilidadesPdf.HeaderFooter(idioma, usuario.getCalleListadosFormateada());
        writer.setPageEvent(event);
		
		document.open();
        
        String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        Paragraph parrafo;
        parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_eu",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloCuadroResultadosClasif_es",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fonttitulo);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        if ("0".equals(resultadoBean.getTerritorio())){
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvascaentero",idioma)+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);      			
        }
        else{
        	parrafo=new Paragraph(resultadoBean.getDescTerritorio().toUpperCase()+" - "+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);
        }
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        
        PdfPTable table;
        PdfPCell cell;
        table=new PdfPTable(2);
        table.setWidthPercentage(100);  
        float[] columnWidths = {0.3f,3f};
        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);       
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.porcentajeSobreTotal",idioma)+": "+resultadoBean.getPorcentaje()+"%",fontnormalpeq));
        	cell.setBorder(0);
        	table.addCell(cell);
        }  
        else{
        	cell = new PdfPCell(new Phrase(""));
        	cell.setBorder(0);
        	table.addCell(cell);
        }
        document.add(table);
        
        table=new PdfPTable(2);
        table.setWidthPercentage(100);       
        columnWidths = new float[]{4f, 1f};
        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.datosgenerales",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aDateUtil.getInstance().getLocaleStringFromDate(W83aDateUtil.getInstance().stringToDateIdioma(resultadoBean.getFechaRegistroDefinitivo(),idioma), idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell); 
    	document.add(table);

        table=new PdfPTable(6);
        table.setWidthPercentage(100); 
        columnWidths = new float[]{2f, 1f, 2f, 1f, 2f, 1f};
        table.setWidths(columnWidths);
       
        lista = (ArrayList)cab.get("cabecera");
        int numempresas=lista.size();
        int numcentros=0;
        int numvotos=0;
        int totalelectores=0;
        Iterator it;
        for (int i=0;i<lista.size();i++){
        	numcentros=numcentros+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getNumcentros());
        	numvotos=numvotos+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getTotalvotos());
        	totalelectores=totalelectores+Integer.parseInt(((W83aResultadosBean)lista.get(i)).getNumTrabajadores());
        }
        
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numempresas",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numempresas),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numcentros",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numcentros),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalelectores",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalelectores),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.totalvotantes",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(numvotos),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.porcentaje",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(W83aUtilidades.calcularporcentajePdf(numvotos,totalelectores),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);  

    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numdeleg",idioma),fontnormal));
    	cell.setBorder(0);
    	cell.setColspan(6);
    	table.addCell(cell);  
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.hasta49",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(mapa.get("delegadosmenorigual49")))),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.demasde49",idioma),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(mapa.get("delegadosmayor49")))),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	 
    	cell = new PdfPCell(new Phrase(String.valueOf(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase()),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(mapa.get("delegadosmenorigual49")))+Integer.parseInt(String.valueOf(mapa.get("delegadosmayor49")))),fontnormal));
    	cell.setBorder(0);
    	table.addCell(cell);
        document.add(table);
        parrafo=new Paragraph("*"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.rescentrales",idioma)+"*",fontnormal);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);      
        int numdelegados=0;
        int numdelegadospu=0;
        int numdelegadospr=0;
        int numdelegadospriv=0;
        int numdelegadospubl=0;
        int numdelegadostotal=0;
        if (!"0".equals(resultadoBean.getTerritorio())){
        	table=new PdfPTable(7);
            table.setWidthPercentage(100); 
            columnWidths = new float[]{1f, 5f, 1f, 1f, 1f, 1f, 1f};
            table.setWidths(columnWidths);
            cell = new PdfPCell(new Phrase("",fontnormal));
            cell.setColspan(3);
            cell.setBorder(0);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(String.valueOf(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.representantes",idioma).toUpperCase()),fontnormal));
            cell.setColspan(3);
            cell.setBorder(0);
            cell.setBorder(Rectangle.BOTTOM);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(""));
            cell.setBorder(0);
         	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma),fontnormal));
        	cell.setColspan(3);
        	cell.setBorder(0);
        	cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.func",idioma),fontnormal));
            cell.setBorder(0);
            cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.labo",idioma),fontnormal));
            cell.setBorder(0);
            cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma),fontnormal));
            cell.setBorder(0);
            cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","%",idioma),fontnormal));
            cell.setBorder(0);
            cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            
            String[] valores;
            m = new TreeMap((Map)mapa.get(resultadoBean.getTerritorio()));
            Set ref = m.keySet();
            for( it = ref.iterator(); it.hasNext();) {
            	String a=(String)it.next();
            	Map c=(HashMap)m.get(a);
            	if (c!=null){
            		if (c.get("F")!=null){
    		            numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("F"));
            		}
            		if (c.get("L")!=null){
            			numdelegadostotal=numdelegadostotal+Integer.parseInt((String)c.get("L"));
            		}
            	}
            }
            ref = m.keySet();
            int delegados=0;
            int func=0;
            int labo=0;
            int tot=0;
            
            boolean otros=false;
            //ordenar descendientemente
            int cont=0;
            
            SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
            int numdelegadosUnico=0;
            for( it = ref.iterator(); it.hasNext();) {
            	cont++;
            	numdelegadosUnico=0;
            	String a=(String)it.next();
            	valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
		            if (c.get("F")!=null){
		            	numdelegadosUnico=numdelegadosUnico+Integer.parseInt((String)c.get("F"));
			       }
	        		if (c.get("L")!=null){
	        			numdelegadosUnico=numdelegadosUnico+Integer.parseInt((String)c.get("L"));
			       }
	        	}
	            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(numdelegadosUnico))+"#"+String.valueOf(cont),a);
	        }
          //fin ordenar descendientemente
         Iterator iterator = map.keySet().iterator();
         while (iterator.hasNext()) {
	        Object key = iterator.next();
	        String valorClave=(String)map.get(key);
	        numdelegados=0;
	     	numdelegadospr=0;
	     	numdelegadospu=0;
	     	
	     	String a=valorClave;
	        valores=a.split("\\|");
	        Map c=(HashMap)m.get(valorClave);
	         if (c!=null){
		            if (c.get("F")!=null){
		            	numdelegados=Integer.parseInt((String)c.get("F"));
			            numdelegadospu=Integer.parseInt((String)c.get("F"));
			            numdelegadospubl=numdelegadospubl+numdelegados;
	     		}
	     		if (c.get("L")!=null){
	     				numdelegados=Integer.parseInt((String)c.get("L"));
			            numdelegadospr=Integer.parseInt((String)c.get("L"));
			            numdelegadospriv=numdelegadospriv+numdelegados;
	     		}
	         }
	         if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(numdelegadospu+numdelegadospr,numdelegadostotal)*100<porcentajeFiltro.floatValue()){
	         	delegados=delegados+numdelegadospu+numdelegadospr;
	         	if (c.get("F")!=null){
	         		func=func+Integer.parseInt((String)c.get("F"));
	         	}
	         	if (c.get("L")!=null){
	         		labo=labo+Integer.parseInt((String)c.get("L"));
	         	}
	         	tot=tot+numdelegadospu+numdelegadospr;
	         	otros=true;
	         }
	         else{
		            if ("null".equals(valores[0])||valores[0]==null){
		            	cell = new PdfPCell(new Phrase(""));//NOPMD		            	
		            }
		            else{
		            	cell = new PdfPCell(new Phrase(valores[0],fontnormalpeq));//NOPMD
		            }
		            cell.setBorder(0);
	                table.addCell(cell);
		            if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
		            	if ("null".equals(valores[1])||valores[1]==null){
		            		cell = new PdfPCell(new Phrase(""));//NOPMD
		            	}
		            	else{
		            		cell = new PdfPCell(new Phrase(valores[1],fontnormalpeq));//NOPMD
		            	}
		            }
		            else{
		            	if ("null".equals(valores[2])||valores[2]==null){
		            		cell = new PdfPCell(new Phrase(""));//NOPMD
		            	}
		            	else{
		            		cell = new PdfPCell(new Phrase(valores[2],fontnormalpeq));//NOPMD
		            	}
		            	
		            }
		            cell.setBorder(0);
	                table.addCell(cell);
	         	
	            cell = new PdfPCell(new Phrase("",fontnormalpeq));//NOPMD
	            cell.setBorder(0);
	            table.addCell(cell);
	            //Convenios
	         	if (c!=null){
	         		if (c.get("F")!=null){
	         			celdaValor(cell,table,W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(c.get("F")))),fontnormalpeq);	 		          
	 		       }
	         		else{
	         			celdaCero(cell,table,fontnormalpeq);
	         		}
	         		if (c.get("L")!=null){
		                celdaValor(cell,table,W83aUtilidades.separadorMiles(Integer.parseInt(String.valueOf(c.get("L")))),fontnormalpeq);
	 		       }
	         		else{
		                celdaCero(cell,table,fontnormalpeq);
	         		}
	         	}
	         	celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospu+numdelegadospr),fontnormalpeq);
	         	celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospu+numdelegadospr,numdelegadostotal),fontnormalpeq);
	         }
         }
           if(otros){
        	   cell = new PdfPCell(new Phrase(""));
               cell.setBorder(0);
               table.addCell(cell);
               cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormalpeq));
               cell.setBorder(0);
               table.addCell(cell);
               cell = new PdfPCell(new Phrase(""));
               cell.setBorder(0);
               table.addCell(cell);
               celdaValor(cell,table,W83aUtilidades.separadorMiles(func),fontnormalpeq);
               celdaValor(cell,table,W83aUtilidades.separadorMiles(labo),fontnormalpeq);
               celdaValor(cell,table,W83aUtilidades.separadorMiles(tot),fontnormalpeq);
               celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(delegados,numdelegadostotal),fontnormalpeq);
            }
            cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase(),fontnormalpeq));
            cell.setBorder(0);
            cell.setBorder(Rectangle.TOP);
            table.addCell(cell); 
            celdaValorTop(cell,table,"",fontnormalpeq);
            celdaValorTop(cell,table,"",fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadospubl),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadospriv),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadospubl+numdelegadospriv),fontnormalpeq);           
            celdaValorTop(cell,table,"",fontnormalpeq);
            document.add(table);
        }else{
        	table=new PdfPTable(17);
            table.setWidthPercentage(100); 
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(2);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.araba",idioma),fontnormalpeq));
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(3);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.bizkaia",idioma),fontnormalpeq));
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(3);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.gipuzkoa",idioma),fontnormalpeq));
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(3);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.comautvasca",idioma),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setColspan(3);
            table.addCell(cell);
            
            cell=new PdfPCell(new Phrase(""));;
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
            cell.setColspan(2);
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(2);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
            cell.setColspan(2);
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(2);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
            cell.setColspan(2);
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(2);
     	    cell.setBorder(0);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.delegados",idioma).toUpperCase(),fontnormalpeq));
            cell.setColspan(2);
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(""));
            cell.setColspan(2);
     	    cell.setBorder(0);
            table.addCell(cell);
            
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.central",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase("%",fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase("%",fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase("%",fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.publ",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.priv",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.tot",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
            cell=new PdfPCell(new Phrase("%",fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.BOTTOM);
            table.addCell(cell);
        	
            m = new TreeMap((Map)mapa.get("todos"));
            Set ref = m.keySet();
    		int ntpa=0;
    		int ntpb=0;
    		int ntpg=0;
    		int ntpra=0;
    		int ntprb=0;
    		int ntprg=0;
    		int nt=0;
    		for( it = ref.iterator(); it.hasNext();) {
    			String a=(String)it.next();
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				ntpa=ntpa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				ntpb=ntpb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				ntpg=ntpg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				ntpra=ntpra+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				ntprb=ntprb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				ntprg=ntprg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		
	            }
	            nt=ntpa+ntpb+ntpg+ntpra+ntprb+ntprg;
            }
    		ref = m.keySet();
    		String[] valores;
    		int numdelegadospubla=0;
    		int numdelegadospublb=0;
    		int numdelegadospublg=0;
    		int numdelegadospriva=0;
    		int numdelegadosprivb=0;
    		int numdelegadosprivg=0;
    		int numdelegadostotpubla=0;
    		int numdelegadostotpublb=0;
    		int numdelegadostotpublg=0;
    		int numdelegadostotpriva=0;
    		int numdelegadostotprivb=0;
    		int numdelegadostotprivg=0;
    		int numdelegadospublapor=0;
    		int numdelegadospublbpor=0;
    		int numdelegadospublgpor=0;
    		int numdelegadosprivapor=0;
    		int numdelegadosprivbpor=0;
    		int numdelegadosprivgpor=0;
    		int numdelegadostotpublapor=0;
    		int numdelegadostotpublbpor=0;
    		int numdelegadostotpublgpor=0;
    		int numdelegadostotprivapor=0;
    		int numdelegadostotprivbpor=0;
    		int numdelegadostotprivgpor=0;
    		boolean otros=false;
    		//ordenar descencientemente
    		int cont=0;
            SortedMap map = new TreeMap(java.util.Collections.reverseOrder());
            for( it = ref.iterator(); it.hasNext();) {
            	cont++;
            	numdelegados=0;
            	numdelegadospr=0;
            	numdelegadospu=0;
            	int nuestroalava=0;
        		int nuestrovizcaya=0;
        		int nuestroguipuzcoa=0;
            	String a=(String)it.next();
	            valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            		}
	        		
	            }
	            map.put(W83aUtilidadesComunes.rellenarCeros(String.valueOf(nuestroalava+nuestrovizcaya+nuestroguipuzcoa))+"#"+String.valueOf(cont),a);
	        }
    		//fin ordenar descendientemente
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
            	Object key = iterator.next();
            	String valorClave=(String)map.get(key);
    			numdelegadospubla=0;
        		numdelegadospublb=0;
        		numdelegadospublg=0;
        		numdelegadospriva=0;
        		numdelegadosprivb=0;
        		numdelegadosprivg=0;
        		int nuestroalava=0;
        		int nuestrovizcaya=0;
        		int nuestroguipuzcoa=0;
        		String a=valorClave;
	            valores=a.split("\\|");
	            Map c=(HashMap)m.get(a);
	            if (c!=null){
	            	if (c.get("F")!=null){
            			Map t=(Map)c.get("F");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            		}
            		if (c.get("L")!=null){
            			Map t=(Map)c.get("L");
            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
            				nuestroguipuzcoa=nuestroguipuzcoa+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
            				nuestrovizcaya=nuestrovizcaya+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
            			}
            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
            				nuestroalava=nuestroalava+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
            			}
            		}
            	}
	            if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83aUtilidades.porcentaje(nuestroalava+nuestrovizcaya+nuestroguipuzcoa,nt)*100<porcentajeFiltro.floatValue()){
	            	if (c!=null){
		            	if (c.get("F")!=null){
	            			Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				numdelegadospublg=numdelegadospublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadospublgpor=numdelegadospublgpor+numdelegadospublg;
	            				numdelegadostotpublg=numdelegadostotpublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotpublgpor=numdelegadostotpublgpor+numdelegadostotpublg;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				numdelegadospublb=numdelegadospublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadospublbpor=numdelegadospublbpor+numdelegadospublb;
	            				numdelegadostotpublb=numdelegadostotpublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotpublbpor=numdelegadostotpublbpor+numdelegadostotpublb;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				numdelegadospubla=numdelegadospubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadospublapor=numdelegadospublapor+numdelegadospubla;
	            				numdelegadostotpubla=numdelegadostotpubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpublapor=numdelegadostotpublapor+numdelegadostotpubla;
	            			}
	            		}
	            		if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				numdelegadosprivg=numdelegadosprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadosprivgpor=numdelegadosprivgpor+numdelegadosprivg;
	            				numdelegadostotprivg=numdelegadostotprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotprivgpor=numdelegadostotprivgpor+numdelegadostotprivg;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				numdelegadosprivb=numdelegadosprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadosprivbpor=numdelegadosprivbpor+numdelegadosprivb;
	            				numdelegadostotprivb=numdelegadostotprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotprivbpor=numdelegadostotprivbpor+numdelegadostotprivb;
	            			}
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				numdelegadospriva=numdelegadospriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadosprivapor=numdelegadosprivapor+numdelegadospriva;
	            				numdelegadostotpriva=numdelegadostotpriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotprivapor=numdelegadostotprivapor+numdelegadostotpriva;
	            			}
	            		}
	            	}
	            	otros=true;
	            }
	            else{
	            
		            if ("null".equals(valores[0])||valores[0]==null){
		            	cell=new PdfPCell(new Phrase(""));//NOPMD
		         	    cell.setBorder(0);
		                table.addCell(cell);
		            }
		            else{
		            	cell=new PdfPCell(new Phrase(valores[0],fontnormalpeq));//NOPMD
		         	    cell.setBorder(0);
		                table.addCell(cell);
		            }
		            if (c!=null){
		            	if (c.get("F")!=null){
		            		Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA),fontnormalpeq));//NOPMD
	            				}		
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadospubla=numdelegadospubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpubla=numdelegadostotpubla+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}
		            	}
		            	else{
		            		celdaCero(cell,table,fontnormalpeq);
		            	}
	            		if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_ALAVA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA),fontnormalpeq));//NOPMD
	            				}
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadospriva=numdelegadospriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            				numdelegadostotpriva=numdelegadostotpriva+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_ALAVA));
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}
	            		}
	            		else{
	            			celdaCero(cell,table,fontnormalpeq);
	            		}
	            		celdaValor(cell,table,String.valueOf(numdelegadospubla+numdelegadospriva),fontnormalpeq);
	            		celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospubla+numdelegadospriva,ntpa+ntpra),fontnormalpeq);
		                if (c.get("F")!=null){
		            		Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA),fontnormalpeq));//NOPMD
	            				}
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadospublb=numdelegadospublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotpublb=numdelegadostotpublb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}            	
	            		}
		                else{
		                	celdaCero(cell,table,fontnormalpeq);
		                }
		                if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_BIZKAIA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA),fontnormalpeq));//NOPMD
	            				}
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadosprivb=numdelegadosprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            				numdelegadostotprivb=numdelegadostotprivb+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_BIZKAIA));
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}
	            		}
		                else{
		                	celdaCero(cell,table,fontnormalpeq);
		                }
		                celdaValor(cell,table,String.valueOf(numdelegadospublb+numdelegadosprivb),fontnormalpeq);
		                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublb+numdelegadosprivb,ntpb+ntprb),fontnormalpeq);
		                if (c.get("F")!=null){
		            		Map t=(Map)c.get("F");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA),fontnormalpeq));//NOPMD
	            				}	
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadospublg=numdelegadospublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotpublg=numdelegadostotpublg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}
		            	}
		                else{
		                	celdaCero(cell,table,fontnormalpeq);
		                }
		                if (c.get("L")!=null){
	            			Map t=(Map)c.get("L");
	            			if (t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA)!=null){
	            				if ("".equals((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA))){
	            					cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));//NOPMD
	            				}
	            				else{
	            					cell=new PdfPCell(new Phrase((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA),fontnormalpeq));//NOPMD
	            				}
	            				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	    		         	    cell.setBorder(0);
	    		                table.addCell(cell);
	            				numdelegadosprivg=numdelegadosprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            				numdelegadostotprivg=numdelegadostotprivg+Integer.parseInt((String)t.get(W83aClsConstantes.CONSTANTE_GIPUZKOA));
	            			}
	            			else{
	            				celdaCero(cell,table,fontnormalpeq);
	            			}
	            	
	            		}
		                else{
		                	celdaCero(cell,table,fontnormalpeq);
		                }
		                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublg+numdelegadosprivg),fontnormalpeq);
		                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublg+numdelegadosprivg,ntpg+ntprg),fontnormalpeq);
		            }
		            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospubla+numdelegadospublb+numdelegadospublg),fontnormalpeq);
		            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospriva+numdelegadosprivb+numdelegadosprivg),fontnormalpeq);
		            celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospubla+numdelegadospublb+numdelegadospublg+numdelegadospriva+numdelegadosprivb+numdelegadosprivg),fontnormalpeq);
		            celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospubla+numdelegadospublb+numdelegadospublg+numdelegadospriva+numdelegadosprivb+numdelegadosprivg,nt),fontnormalpeq);
		        }//fin del else
            }
    		if(otros){
    			cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormalpeq));
         	    cell.setBorder(0);
                table.addCell(cell);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublapor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivapor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublapor+numdelegadosprivapor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublapor+numdelegadosprivapor,ntpa+ntpra),fontnormalpeq);               
                
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublbpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivbpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublb+numdelegadosprivbpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublbpor+numdelegadosprivbpor,ntpb+ntprb),fontnormalpeq);
                
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublgpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivgpor),fontnormalpeq); 
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublgpor+numdelegadosprivgpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublgpor+numdelegadosprivgpor,ntpg+ntprg),fontnormalpeq);
                
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.separadorMiles(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor+numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor),fontnormalpeq);
                celdaValor(cell,table,W83aUtilidades.calcularporcentajePdf(numdelegadospublapor+numdelegadospublbpor+numdelegadospublgpor+numdelegadosprivapor+numdelegadosprivbpor+numdelegadosprivgpor,nt),fontnormalpeq);
    			
    		}
    		cell=new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",idioma).toUpperCase(),fontnormalpeq));
     	    cell.setBorder(0);
     	    cell.setBorder(Rectangle.TOP);
            table.addCell(cell);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpubla),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpriva),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpubla+numdelegadostotpriva),fontnormalpeq);
            celdaValor(cell,table,"",fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublb),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprivb),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublb+numdelegadostotprivb),fontnormalpeq);
            celdaValor(cell,table,"",fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublg),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotprivg),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpublg+numdelegadostotprivg),fontnormalpeq);
            celdaValor(cell,table,"",fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpubla+numdelegadostotpublg+numdelegadostotpublb),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpriva+numdelegadostotprivb+numdelegadostotprivg),fontnormalpeq);
            celdaValorTop(cell,table,W83aUtilidades.separadorMiles(numdelegadostotpubla+numdelegadostotpublg+numdelegadostotpublb+numdelegadostotpriva+numdelegadostotprivb+numdelegadostotprivg),fontnormalpeq);
            celdaValor(cell,table,"",fontnormalpeq);
            document.add(table);
        	}
            
        document.close();
        if (!"0".equals(resultadoBean.getTerritorio())){
        	W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"vertical");
        }
        else{
        	W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"horizontal");
        }
		
		
		OutputStream out = response.getOutputStream();	        
        baos.writeTo(out);
        out.flush();			
	    out.close();
		
    	return null;
	}

	public void celdaCero(PdfPCell cell, PdfPTable table, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(String.valueOf(0),fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
	public void celdaValor(PdfPCell cell, PdfPTable table, String valor, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(valor,fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
	public void celdaValorTop(PdfPCell cell, PdfPTable table, String valor, Font fontnormalpeq){//NOPMD
		cell=new PdfPCell(new Phrase(valor,fontnormalpeq));
 	    cell.setBorder(0);
 	    cell.setBorder(Rectangle.TOP);
 	    cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
        table.addCell(cell);
	}
}

